/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui.secureftp.internal;

import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.filesystem.secureftp.ISFTPConnectionPoint;
import com.aptana.ui.ftp.internal.IOptionsComposite;
import com.aptana.ui.ftp.internal.NumberVerifyListener;
import com.aptana.ui.secureftp.internal.Messages;
import java.nio.charset.Charset;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SFTPAdvancedOptionsComposite
extends Composite
implements IOptionsComposite {
    private IOptionsComposite.IListener listener;
    private Combo compressionCombo;
    private Text portText;
    private Combo encodingCombo;
    private ModifyListener modifyListener;

    public SFTPAdvancedOptionsComposite(Composite parent, int style, IOptionsComposite.IListener listener) {
        super(parent, style);
        this.listener = listener;
        this.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(5).spacing(new PixelConverter((Control)this).convertHorizontalDLUsToPixels(4), new PixelConverter((Control)this).convertVerticalDLUsToPixels(4)).create());
        Label label = new Label((Composite)this, 0);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().hint(new PixelConverter((Control)this).convertHorizontalDLUsToPixels(55), -1).create());
        label.setText(StringUtil.makeFormLabel((String)Messages.SFTPAdvancedOptionsComposite_Compression));
        this.compressionCombo = new Combo((Composite)this, 2060);
        this.compressionCombo.add("AUTO");
        this.compressionCombo.add("NONE");
        this.compressionCombo.add("ZLIB");
        this.compressionCombo.setLayoutData((Object)GridDataFactory.swtDefaults().hint(this.compressionCombo.computeSize((int)-1, (int)-1, (boolean)true).x, -1).create());
        label = new Label((Composite)this, 0);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().align(0x1000008, 0x1000000).hint(new PixelConverter((Control)this).convertHorizontalDLUsToPixels(55), -1).create());
        label = new Label((Composite)this, 0);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        label.setText(StringUtil.makeFormLabel((String)Messages.SFTPAdvancedOptionsComposite_Port));
        this.portText = new Text((Composite)this, 133124);
        this.portText.setLayoutData((Object)GridDataFactory.swtDefaults().hint(Math.max(new PixelConverter((Control)this.portText).convertWidthInCharsToPixels(5), this.portText.computeSize((int)-1, (int)-1, (boolean)true).x), -1).create());
        label = new Label((Composite)this, 0);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().hint(new PixelConverter((Control)this).convertHorizontalDLUsToPixels(55), -1).create());
        label.setText(StringUtil.makeFormLabel((String)Messages.SFTPAdvancedOptionsComposite_Encoding));
        this.encodingCombo = new Combo((Composite)this, 2060);
        this.encodingCombo.setItems(Charset.availableCharsets().keySet().toArray(ArrayUtil.NO_STRINGS));
        this.encodingCombo.setLayoutData((Object)GridDataFactory.swtDefaults().hint(this.encodingCombo.computeSize((int)-1, (int)-1, (boolean)true).x, -1).span(4, 1).create());
        this.addListeners();
        this.portText.addVerifyListener((VerifyListener)new NumberVerifyListener());
    }

    public void loadPropertiesFrom(Object element) {
        Assert.isLegal((boolean)(element instanceof ISFTPConnectionPoint));
        ISFTPConnectionPoint sftpConnectionPoint = (ISFTPConnectionPoint)element;
        this.removeListeners();
        try {
            int index = this.compressionCombo.indexOf(String.valueOf(sftpConnectionPoint.getCompression()));
            if (index >= 0) {
                this.compressionCombo.select(index);
            }
            this.portText.setText(Integer.toString(sftpConnectionPoint.getPort()));
            index = this.encodingCombo.indexOf(String.valueOf(sftpConnectionPoint.getEncoding()));
            if (index >= 0) {
                this.encodingCombo.select(index);
            }
        }
        finally {
            this.addListeners();
        }
    }

    public boolean savePropertiesTo(Object element) {
        Assert.isLegal((boolean)(element instanceof ISFTPConnectionPoint));
        boolean updated = false;
        ISFTPConnectionPoint sftpConnectionPoint = (ISFTPConnectionPoint)element;
        String compression = this.compressionCombo.getItem(this.compressionCombo.getSelectionIndex());
        if (!sftpConnectionPoint.getCompression().equals(compression)) {
            sftpConnectionPoint.setCompression(compression);
            updated = true;
        }
        int port = Integer.parseInt(this.portText.getText());
        if (sftpConnectionPoint.getPort() != port) {
            sftpConnectionPoint.setPort(port);
            updated = true;
        }
        String encoding = this.encodingCombo.getItem(this.encodingCombo.getSelectionIndex());
        if (!sftpConnectionPoint.getEncoding().equals(encoding)) {
            sftpConnectionPoint.setEncoding(encoding);
            updated = true;
        }
        return updated;
    }

    public String isValid() {
        int port = 0;
        try {
            port = Integer.parseInt(this.portText.getText());
        }
        catch (NumberFormatException e) {
            e.getCause();
        }
        if (port <= 0) {
            return Messages.SFTPAdvancedOptionsComposite_InvalidPort;
        }
        return null;
    }

    public void setValid(boolean valid) {
    }

    public void lockUI(boolean lock) {
        this.compressionCombo.setEnabled(!lock);
        this.portText.setEnabled(!lock);
        this.encodingCombo.setEnabled(!lock);
    }

    protected void addListeners() {
        if (this.modifyListener == null) {
            this.modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SFTPAdvancedOptionsComposite.this.listener.validate();
                }
            };
        }
        this.portText.addModifyListener(this.modifyListener);
    }

    protected void removeListeners() {
        if (this.modifyListener != null) {
            this.portText.removeModifyListener(this.modifyListener);
        }
    }
}

